
plugin simpleManipulator arnoldlight_quadmanip
    name:~ARNOLD_LIGHT_QUAD_MANIP_NAME~
    invisible:true
(
    -- Create the green and red colors for the gizmo
    local greenColor =  colorMan.getColor #manipulatorsActive
    local redColor =    colorMan.getColor #manipulatorsSelected

    on canManipulate target do
	(
		if not hasProperty target #shapeType then
		(
			return false
		)
		else
		(
			shapeType = target.shapeType
			if (shapeType != 3) then
			(
				return false
			)
			else
			(
				return (hasProperty target #quadX) and (hasProperty target #quadY)
			)
		)
	)

    on updateGizmos do
    (
        this.clearGizmos()

		local quadX = target.quadX * 0.505
		local quadY = target.quadY * 0.505
		
		local giz1 = manip.makeGizmoShape()
		giz1.AddPoint([quadX,quadY,0])
		giz1.AddPoint([-quadX,quadY,0])
        this.addGizmoShape giz1 0 greenColor redColor  
		
		local giz2 = manip.makeGizmoShape()
		giz2.AddPoint([quadX,-quadY,0])
		giz2.AddPoint([-quadX,-quadY,0])
        this.addGizmoShape giz2 0 greenColor redColor  
		
		local giz3 = manip.makeGizmoShape()
		giz3.AddPoint([quadX,quadY,0])
		giz3.AddPoint([quadX,-quadY,0])
        this.addGizmoShape giz3 0 greenColor redColor  
		
		local giz4 = manip.makeGizmoShape()
		giz4.AddPoint([-quadX,quadY,0])
		giz4.AddPoint([-quadX,-quadY,0])
        this.addGizmoShape giz4 0 greenColor redColor  
		
        -- return the ToolTip string
        return node.name + " " + ~ARNOLD_LIGHT_QUAD_MANIP_QUAD_X~ + " = " + target.quadX as string + ", " + ~ARNOLD_LIGHT_QUAD_MANIP_QUAD_Y~ + " = " + target.quadY as string
    )

    on mouseMove m which do
    (
        local pl = manip.makePlaneFromNormal z_axis [0, 0, 0],
        projectedPoint = [0,0,0]
		
        viewRay = this.getLocalViewRay m
        res = pl.intersect viewRay &projectedPoint
 
        if (res) then
		(
			if which == 0 then
			(
				target.quadY = projectedPoint[2] / 0.505
				return true
			)
			if which == 1 then
			(
				target.quadY = projectedPoint[2] / -0.505
				return true
			)
			if which == 2 then
			(
				target.quadX = projectedPoint[1] / 0.505
				return true
			)
			if which == 3 then
			(
				target.quadX = -projectedPoint[1] / 0.505
				return true
			)
		)
		
		-- TL if the point wasn't on the plane, can't really resize the quad so disregard (best solution I could come up with) 
		
    )
	
	on MouseDown m which do
	(

	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC9+AQFJI+WUw2J4A47NflmeL/k1umlGNtz
-- Tez16g2fohE+Ub8fQHJqNeoJVKEMkgKbVhk4iVjYkQjHuoJHCFskp8kGNHb5Uw/7
-- AETGFocQ2nsgTIn8avUuxx+aEmyjDCEnwCIHpWOlua+XEJJeuyxD/BJl2CMxJGpp
-- gB1LVT5wabgJskzyTAFNkKMghDfp1uCYOBpHR31YJQQu+0z76fnUwGcnNncZaSaB
-- kWXA1+rSUeZy8e3w114Gyc03NMidTDMTo3JzSUly3/kf8BDuqvMzFDIIZPX2XcSH
-- xeY7IcgxcBQhW/z3yBEVpjx56HQL4pkps+iIaX+t2Yyt3+/28pYL
-- -----END-SIGNATURE-----